#include <iostream>
#include <vector>

using namespace std;

int *read(int n) {
    int *t = new int[n];
    for (int i = 0; i < n; i++)
        scanf("%d", t + i);
    return t;
}

void psum(int n, int *t) {
    for (int i = 1; i < n; i++)
        t[i] += t[i - 1];
}

int bsearch(int n, int *t, int k) {
    if (n == 0)
        return 0;

    int p = 0, q = n - 1;
    while (p < q) {
        int s = (p + q + 1) / 2;
        if (t[s] > k)
            q = s - 1;
        else
            p = s;
    }
    return t[p];
}

void solve() {
    int n, k;
    scanf("%d%d", &n, &k);
    int *a = read(n);
    psum(n, a);

    bool possible = false;
    for (int i = 0; i < n && !possible; i++) {
        if (a[i] > k)
            break;
        int p = bsearch(n - i, a + i, k + a[i]) - a[i];
        //cout << p << endl;
        if (p <= a[i])
            possible = true;
    }
    cout << (possible ? "da" : "ne") << endl;

    delete[] a;
}

int main() {
    int t;
    cin >> t;
    for (; t > 0; t--) {
        solve();
    }
    return 0;
}